/*----------------------------------------------------------------------------
 * Name     : main.c
 * Purpose  : EPD21 Verify Kit
 * Note(s)  :
 *----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2012 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------*/

#include    <stdio.h>
#include    <stdlib.h>
#include    <string.h>
#include		<math.h>
#include    "main.h"
#include    "timer.h"
#include    "lcm.h"
#include    "led.h"
#include    "button.h"
#include    "ht32f5xxxx_exti.h"
#include    "HT32_BLE_lib.h"


// <<< Use Configuration Wizard in Context Menu >>>

//	<e> Change Connect Interval Enable
#define	_CHG_CNNT_INTV_ENABLE_   (1)
//		<o> Connect Interval(ms)<10-80000>
#define 	_CHG_CNNT_INTV_VALUE_  (30)
//	</e>

//	<e> MCU sleep mode Enable/disable
#define	_MCU_SLEEP_ENABLE_  (0)
//		<o> Enter deep sleep delay timer(ms)<10-5000>
#define 	_SLEEP_DELAY_TIMER_  (500)
//	</e>

//	<h> WakeUp Signal Configure
//		<o> Wake up Signal Width(byte)<1-8>
#define 	_MASTER_WUW_VALUE_  (2)
//		<o> Wake up Signal delay time(ms)<0-20>
#define 	_MASTER_WUT_VALUE_  (8)
//	</h>

//	<e> External 32.768KHZ Crystal Configure Enable
#define	_EXTERNAL32_CFG_ENABLE_   (0)
//	</e>

// <o> Crystal C0Load<0-15>
#define 	_CLOAD_VALUE_  (4)

// <o> Tx Power<0-15>
#define 	_TX_POWER_VALUE_  (15)



//<<< end of configuration section >>>

//#define DEFAULT_BAUDRATE   9600
#define DEFAULT_BAUDRATE   115200

#define CHANGE_BAUDRATE   125000

#define	UART_RXD_PORT				HT_GPIOC
#define	UART_RXD						GPIO_PIN_3
#define	UART_RXD_AFIO_PORT		GPIO_PC
#define	UART_RXD_AFIO_FUN			AFIO_FUN_USART_UART

#define	UART_WAKEUP_ESS_PORT		AFIO_ESS_PC             /* PORT C */
#define	UART_WAKEUP_EXIT_CH     AFIO_EXTI_CH_3				  /* PC3 for UART RXD */


//BLE reset by PB15
#define	RESET_PIN_PORT				HT_GPIOB
#define	RESET_PIN						  GPIO_PIN_15
#define	RESET_AFIO_PORT			  GPIO_PB
#define	RESET_AFIO_FUN				AFIO_FUN_GPIO

u8 cnt,cnt1;

union
{
	u16	U;
	struct
	{
		u16	ButtonChange: 1;
		u16	BLE_ConnectState: 1;
		u16	BLE_PwrOnDisplay: 1;
		u16	BLE_ConnectDisplay: 1;
		u16	BLE_NotWakeUp:1;
		u16	BLE_WakeUpDelay:1;
		u16	BLE_ServiceMsg:1;
	  u16	BLE_WaitEventRsp:1;
		u16	BLE_ReadCnntIntv:1;
		u16	BLE_WakeUpSignal:1;
      u16:2;
		u16	MCU_EnterSleep:1;
		u16	BLE_Transmit:1;
		u16 BLE_SetConIntv:1;
		u16 BLE_GetConIntv:1;
	}B;
}MFlag;


/* Service properties(Notify or indicate) status flag define */
typedef union
{
	u8	u;
	struct
	{
		u8 battery:1;
		u8 bps_measurement:1;
		u8 wss_measurement:1;
		u8	uwsFFF1:1;
		u8	:4;
	}b;
}tPROPERTIES;


u8		key_status;
bool	LEDStatusUpdate;
u8		BLEWakeUpDlyTm;
bool	BLESleepMode;
u16	BLESleepDlyTm;


#define	WAIT_RESPONSE_TIME		500 


tPROPERTIES		ServiceProperties;
tKEY_MESSAGE	Hmessage,Dmessage;
u16	ConnectIntervalTime;
u16 BLEInitTm;



typedef enum
{
	BLE_set_baudrate = 0,
	BLE_read_dateCode,
	BLE_get_btAddr,
	BLE_set_CL,
	BLE_set_pwr,
	BLE_set_deviceName,
	BLE_set_AdvData,
	BLE_set_scanData,
	BLE_set_AdvInterval,
	BLE_set_DevInfo,
	BLE_set_feature,
	BLE_set_advEnable,
	BLE_advDelay,
	BLE_power_on_ok,
	BLE_power_on_fail,
} en_BLE_InitSt;

en_BLE_InitSt BLE_InitSt = BLE_read_dateCode;	

u8 BLE_DeviceName[] = {'B', 'M', '6', '7', 'C', '7', '4', '1', '-', '1'};

u8	BLE_AdvData[] =
{
	/* flag */
	2,0x01,0x06,
//	8,0x16,0x1C,0x2A,0x01,0x23,0x00,0x00,0x00,
	/* Manufacturer Specific Data */
	11,0xFF,0xFF,0xFF,
	'H','o','l','t','e','k','0','1'
};

u8	BLE_ScanData[] =
{
	/* complete List of 16-bit Service Class UUIDs */
	11,0x03,0x00,0x18,0x01,0x18,0x0A,0x18,0x0F,0x18,0xF0,0xFF
};

u8	BLE_DevInfManufacturer[] = {'H','O','L','T','E','K'};		//max 16 byte

u8 BLE_firstInit=1;
tDEV_ADDR devAddr;
tADV_INTV devAdvIntv={0};
tCNNT_INTV devConIntv={0};
u8 devAddr_type=0xff;


void BLE_Evt(u16 type, en_BLE_St evt_status, u8 *buffer, u8 buffer_Len)
{
	//BLE iniital
	if(evt_status == BLE_ST_SUCCESS && BLE_firstInit == 1)
	{
		BLEInitTm = WAIT_RESPONSE_TIME;
    if(type == BLE_BAUDRATE)
		{
			BLE_InterfaceConfigure(CHANGE_BAUDRATE);
			BLE_GetVersion();
			BLE_InitSt++;
		}		
		else if(type == BLE_VERSION)
		{
			 BLE_GetDeviceAddress();
			 BLE_InitSt++;
		}	
		else if(type == BLE_DEV_ADDRESS)
		{
			memcpy(&(devAddr.addr),((tDEV_ADDR *)buffer)->addr,6);
		  devAddr_type=((tDEV_ADDR *)buffer)->type;
			
			BLE_SetCrystalCload(_CLOAD_VALUE_);
			BLE_InitSt++;
		}
		else if(type == BLE_CLOAD_SET)
		{
			BLE_SetTxPower(_TX_POWER_VALUE_);
			BLE_InitSt++;
		}
		else if(type == BLE_TX_POWER)
		{
			BLE_SetDeviceName(BLE_DeviceName,sizeof(BLE_DeviceName));
			BLE_InitSt++;
		}
		else if(type == BLE_DEV_NAME)
		{
			BLE_SetAdvertisingData(BLE_AdvData,sizeof(BLE_AdvData));
			BLE_InitSt++;
		}
		else if(type == BLE_ADV_DATA)
		{
			BLE_SetScanResponseData(BLE_ScanData,sizeof(BLE_ScanData));
			BLE_InitSt++;
		}
		else if(type == BLE_SCAN_DATA)
		{
			BLE_SetAdvertisingInterval(160,160);
			BLE_InitSt++;
		}
		else if(type == BLE_ADV_INTV)
		{
			BLE_SetCharacteristicValue(ManufacturerNameString,BLE_ServiceMessage,BLE_DevInfManufacturer,sizeof(BLE_DevInfManufacturer));
			BLE_InitSt++;
		}
		else if(type == ManufacturerNameString)
		{
#if(_EXTERNAL32_CFG_ENABLE_)
			BLE_SetFeature((FeatureFlag)FEATURE_STATUS_EVENT | FEATURE_EXTERNAL32K);         //with external 32K XT
#else
			BLE_SetFeature(FEATURE_STATUS_EVENT);                                              //without external 32K XT
#endif
			BLE_InitSt++;
		}
		else if(type == BLE_FEATURE_CTRL)
		{
			BLE_SetAdvertising(ENABLE);
			BLE_InitSt++;
		}
		else if(type == BLE_ADV_CTRL)
		{
			delay_ms(800);                                     //delay 800ms after turn on rf.can not send command in this peroid
			BLE_InitSt++;
			BLE_firstInit=0;
		}	
		return;
	}	



	if((type == BLE_CONN_INTV || type == BLE_CONN_INTV1)&& evt_status == BLE_ST_SUCCESS)		
	{
		if(buffer_Len)
		{
			ConnectIntervalTime = (buffer[1] << 8) + buffer[0];
			ConnectIntervalTime = (u16)((float)ConnectIntervalTime * 1.25 + 0.5);
			lcm_printf(6,0,DSP_NORMAL,LCM_FONT8X8,"CnT=%d",ConnectIntervalTime);
		}
    MFlag.B.BLE_WaitEventRsp = FALSE;
	}
	
	if(type == BLE_OPERATE_MODE && evt_status == BLE_ST_SUCCESS && buffer_Len==0)		 
	 {
#if (_MCU_SLEEP_ENABLE_ == 1)
		 MFlag.B.MCU_EnterSleep = TRUE;
#endif	
	 		BLESleepMode = TRUE;
		  MFlag.B.BLE_WaitEventRsp = FALSE;			 
	 }
	
	if(type == WithoutResponseFFF2 && buffer_Len == 4 && buffer[0] == 0xB0 && evt_status == BLE_ST_SUCCESS)
	{
		Hmessage.type = buffer[0];
		Hmessage.key = buffer[1];
		Hmessage.serial = buffer[2];
		Hmessage.checksum = buffer[3];
		LEDStatusUpdate = TRUE;
	}
	
  if(type == NotifyFFF1 && evt_status == 0x20)
  {
		if(buffer_Len	== 2 && buffer[0] == 0xF1 && buffer[1] == 0xFF) ServiceProperties.b.uwsFFF1 = TRUE;
		else  
		MFlag.B.BLE_WaitEventRsp = FALSE;
	}		
 
	 	
	if(type == BLE_STATUS && evt_status == BLE_ST_SUCCESS)
		{
			if(((tSTATUS *)(buffer))->b.Connect)
			{
				MFlag.B.BLE_ConnectState = TRUE;			
			}
			else
			{
				MFlag.B.BLE_ConnectState = FALSE;
			}	
			if(((tSTATUS *)(buffer))->b.PramUpdataPeer)
			{
				MFlag.B.BLE_ReadCnntIntv = TRUE;
#if(_CHG_CNNT_INTV_ENABLE_==0)
        delay_ms(300);
#endif
			}
		}
		
	if(evt_status != BLE_ST_SUCCESS &&  BLE_firstInit == 1) BLE_InitSt = BLE_power_on_fail;

		
}




void BLE_Reset()
{
	CKCU_PeripClockConfig_TypeDef CKCUClock = {{0}};
  CKCUClock.Bit.PB = 1;
  CKCU_PeripClockConfig(CKCUClock, ENABLE);
	
	//BLE reset by PB15
	AFIO_GPxConfig(RESET_AFIO_PORT, RESET_PIN, RESET_AFIO_FUN);
	GPIO_DirectionConfig	(RESET_PIN_PORT	,RESET_PIN	,GPIO_DIR_OUT);
		
	GPIO_WriteOutBits	(RESET_PIN_PORT	,RESET_PIN	,RESET);
	delay_ms(12);
	GPIO_WriteOutBits	(RESET_PIN_PORT	,RESET_PIN	,SET);
		
}


void ParameterInitial()
{
		MFlag.B.BLE_ConnectState =FALSE;
	  BLE_firstInit=1;
}


/*----------------------------------------------------------------------------
  Main Program
 *----------------------------------------------------------------------------*/
int main (void)
{

   CKCU_Configuration();
//   MCU_gpio_Configuration();
   /* -------------- LCM initial ------------------------------------ */
   lcm_bus_configure();
   lcm_configure();
	lcm_put_map((u8 *)BestComm_Logo);
   lcm_put8x16_string((sc8 *)"67C741",0,10,DSP_NORMAL);
   lcm_put8x16_string((sc8 *)"DevKit",1,10,DSP_NORMAL);
   lcm_put8x16_string((sc8 *)"Ver2.0",2,10,DSP_NORMAL);
   lcm_put6x8_string((sc8 *)"22/11/30",6,13,DSP_NORMAL);
   /* -------------- LED/Button IO initial -------------------------- */
   LED_IO_configure();
   BTN_IOConfigure();
	SystickConfigure();
//#if (_RETARGET == 1)
//	RETARGET_Configuration();
//#endif
	 ParameterInitial();
   delay_ms(1000);                      	        /* delay 1s */
   lcm_clear();
   lcm_put8x8_string((s8 *)"BLE PwrOn :     ",0,0,DSP_NORMAL);
   lcm_put8x8_string((s8 *)"BLE Connet: No  ",1,0,DSP_NORMAL);
   lcm_put8x8_string((s8 *)"Host KEY 1: Up  ",2,0,DSP_NORMAL);
   lcm_put8x8_string((s8 *)"Host KEY 2: Up  ",3,0,DSP_NORMAL);
   lcm_put8x8_string((s8 *)"Host KEY 3: Up  ",4,0,DSP_NORMAL);
	 timer_operate.bits.t1ms = FALSE;
   LED_always_on(LEDP);
	 
	 BLE_Reset();                                    //BLE HW reset. IO may differ in different HW.
#if (DEFAULT_BAUDRATE == 9600)
	 BaudRateDefault(9600); 
	 delay_ms(65);                               //wait BLE IO stable, around 65ms
   BLE_InterfaceConfigure(BLE_BAUDRATE_9600);			 
#else
   delay_ms(65);                                   //wait BLE IO stable, around 65ms
	 BLE_InterfaceConfigure(BLE_BAUDRATE_115200);    //BLE interface config
#endif
	 BLE_Init();                                     //BLE initial	
	 BLE_registerEvtCallback(BLE_Evt);               //register BLE event callback. Get value from callback

   BLE_SetBaudRate(CHANGE_BAUDRATE);               //Set Baudrate and ble initial  
	 BLEInitTm = WAIT_RESPONSE_TIME;
	 while (1)
  {
		if(timer_operate.bits.t1ms)
		{
      timer_operate.bits.t1ms = FALSE;
			MFlag.B.ButtonChange = BTN_ScanButtonStatus();
			LED_flash_process();
			if(BLEWakeUpDlyTm) BLEWakeUpDlyTm--;
			if(BLESleepDlyTm) BLESleepDlyTm--;
			if(BLEInitTm) BLEInitTm--;
    }		
		BLE_Routine();	                                //BLE Process
    if(BLE_firstInit==0 && BLE_InitSt==BLE_power_on_ok)
    {
			if(!MFlag.B.BLE_PwrOnDisplay)
			  {
				  lcm_put8x8_string((s8 *)"BLE PwrOn : OK  ",0,0,DSP_NORMAL);				
					lcm_printf(7,0,DSP_NORMAL,LCM_FONT8X8,"BDA=%02X%02X%02X%02X%02X%02X",
								devAddr.addr[5],
								devAddr.addr[4],
								devAddr.addr[3],
								devAddr.addr[2],
								devAddr.addr[1],
								devAddr.addr[0]);			
				  MFlag.B.BLE_PwrOnDisplay = TRUE;
				  BLESleepMode = FALSE;
				  BLESleepDlyTm = _SLEEP_DELAY_TIMER_;
				  MFlag.B.BLE_WaitEventRsp = FALSE;
			  }	
				
			if(MFlag.B.BLE_ConnectState)
				{
					if(!MFlag.B.BLE_ConnectDisplay)
				   { 
					   lcm_put8x8_string((s8 *)"BLE Connet: Yes ",1,0,DSP_NORMAL);
#if (_CHG_CNNT_INTV_ENABLE_ == 1)
						 MFlag.B.BLE_SetConIntv = TRUE;
#endif
					   MFlag.B.BLE_ConnectDisplay = TRUE;
				   }
					 
					if(MFlag.B.BLE_ReadCnntIntv)
				  {					
						 MFlag.B.BLE_GetConIntv = TRUE;
					   MFlag.B.BLE_ReadCnntIntv = FALSE;
				  }
					
 				  if(MFlag.B.ButtonChange)
				  {
					   key_status = BTN_GetButtonStatus();
					   if(ServiceProperties.b.uwsFFF1)
					   {
						    Dmessage.type = (Dmessage.key ^ key_status) & 0x0F;
							  if(Dmessage.type != 0)
						    {
									Dmessage.type = 0xB1;
									Dmessage.key  <<= 4;
									Dmessage.key  |= key_status & 0x0F;
									Dmessage.serial ++;
									Dmessage.checksum =  Dmessage.type ^ Dmessage.key ^ Dmessage.serial;
									MFlag.B.BLE_Transmit=TRUE;
								}
					  }
					   MFlag.B.ButtonChange = FALSE;
				 }
				}			
			else 
				{
					lcm_put8x8_string((s8 *)"BLE Connet: No  ",1,0,DSP_NORMAL);
					lcm_put8x8_clearing(6);
					MFlag.B.BLE_ConnectDisplay = FALSE;
				}
				
				if(LEDStatusUpdate)
			  {
					if(Hmessage.key & 0x01)
					{
						lcm_put8x8_string((s8 *)"Host KEY 1: Dn  ",2,0,DSP_NORMAL);
						LED_always_on(LED1);
					}
					else
					{
						lcm_put8x8_string((s8 *)"Host KEY 1: Up  ",2,0,DSP_NORMAL);
						LED_always_off(LED1);
					}

					if(Hmessage.key & 0x02)
					{
						LED_always_on(LED2);
						lcm_put8x8_string((s8 *)"Host KEY 2: Dn  ",3,0,DSP_NORMAL);
					}
					else
					{
						lcm_put8x8_string((s8 *)"Host KEY 2: Up  ",3,0,DSP_NORMAL);
						LED_always_off(LED2);
					}

					if(Hmessage.key & 0x04)
					{
						LED_always_on(LED3);
						lcm_put8x8_string((s8 *)"Host KEY 3: Dn  ",4,0,DSP_NORMAL);
					}
					else
					{
						lcm_put8x8_string((s8 *)"Host KEY 3: Up  ",4,0,DSP_NORMAL);
						LED_always_off(LED3);
					}
					LEDStatusUpdate = FALSE;
			  }
				
//Wakeup from Deep Sleep Mode								
				
#if (_MCU_SLEEP_ENABLE_	== 1)			
			if( (MFlag.B.BLE_WakeUpSignal || MFlag.B.BLE_Transmit || MFlag.B.BLE_SetConIntv || MFlag.B.BLE_GetConIntv) && !MFlag.B.BLE_WaitEventRsp)
#else
			if((MFlag.B.BLE_Transmit || MFlag.B.BLE_SetConIntv || MFlag.B.BLE_GetConIntv) && !MFlag.B.BLE_WaitEventRsp)
#endif			
			{
				if(BLESleepMode == TRUE)
				{
#if (_MCU_SLEEP_ENABLE_	== 1)								
					MFlag.B.MCU_EnterSleep = FALSE;
#endif					
					if(!MFlag.B.BLE_WakeUpDelay)
					{						
						  BLE_DummyWakeup(2); 
							BLEWakeUpDlyTm = 30;				                           //BLE wake up delay 30ms
							MFlag.B.BLE_WakeUpDelay = TRUE;
					}
					else
					{
						if(BLEWakeUpDlyTm == 0)                                  //BLE to normal mode
						{
							 BLESleepMode = FALSE;
							 MFlag.B.BLE_WakeUpDelay = FALSE;
							 
#if( _MCU_SLEEP_ENABLE_	== 1)
									if(MFlag.B.BLE_WakeUpSignal) BLESleepDlyTm = _SLEEP_DELAY_TIMER_; 
									MFlag.B.BLE_WakeUpSignal = FALSE;
#endif									

						}
					}
				}
				else if( MFlag.B.BLE_Transmit )
				{
								BLE_SetCharacteristicValue(NotifyFFF1,BLE_ServiceProperties,(u8 *)&Dmessage,sizeof(tKEY_MESSAGE));
					      MFlag.B.BLE_WaitEventRsp = TRUE;
							  MFlag.B.BLE_Transmit = FALSE;
				}
				
				else if( MFlag.B.BLE_SetConIntv)
				{
	              BLE_SetConnectInterval(_CHG_CNNT_INTV_VALUE_/1.25,_CHG_CNNT_INTV_VALUE_/1.25);	             
						    MFlag.B.BLE_WaitEventRsp =TRUE;
						    MFlag.B.BLE_SetConIntv = FALSE;				
				}
				else if( MFlag.B.BLE_GetConIntv )
				{
//					      delay_ms(300);
					      BLE_GetConnectInterval();
						    MFlag.B.BLE_WaitEventRsp = TRUE;
                MFlag.B.BLE_GetConIntv =FALSE;					
				}
			}
				
			
//BLE to Deep Sleep Mode			
if(!BLESleepMode && !MFlag.B.BLE_Transmit && !MFlag.B.BLE_SetConIntv && !MFlag.B.BLE_GetConIntv && !MFlag.B.BLE_WaitEventRsp)
			{
#if (_MCU_SLEEP_ENABLE_ == 0)				
				  key_status = BTN_GetButtonStatus();				
				if((key_status == 0) && !MFlag.B.BLE_Transmit && !MFlag.B.BLE_SetConIntv && !MFlag.B.BLE_GetConIntv)
				{					
					if(BLESleepDlyTm == 0)
					{			
            BLE_SetPowerSaving(OP_DEEPSLEEP);
						MFlag.B.BLE_WaitEventRsp = TRUE;						
					}					
				}
								
#else
				key_status = BTN_GetButtonStatus();				
				if((key_status == 0) && !MFlag.B.BLE_Transmit && !MFlag.B.BLE_SetConIntv && !MFlag.B.BLE_GetConIntv)
				{
					if(BLESleepDlyTm == 0)
					{																		
						BLE_SetPowerSavingSlaveWakeup(OP_DEEPSLEEP,ENABLE,_MASTER_WUT_VALUE_,_MASTER_WUW_VALUE_); 
						MFlag.B.BLE_WaitEventRsp = TRUE;
					}
				}	
#endif		

				else
				{
					BLESleepDlyTm = _SLEEP_DELAY_TIMER_;
				}			
			}	
		}	

if((BLE_InitSt == BLE_power_on_fail || !BLEInitTm ) && BLE_firstInit==1)
	{
		if(!MFlag.B.BLE_PwrOnDisplay)
			{
				lcm_put8x8_string((s8 *)"BLE PwrOn : Fail",0,0,DSP_NORMAL);
				MFlag.B.BLE_PwrOnDisplay = TRUE;
			}
	}
		
#if (_MCU_SLEEP_ENABLE_	== 1)
		if(MFlag.B.MCU_EnterSleep)
		{
			MFlag.B.MCU_EnterSleep = FALSE;
			MCU_SleepModeProcess();
			MFlag.B.BLE_WakeUpSignal = TRUE;
		}
#endif
			
		
  }

}

#if (_MCU_SLEEP_ENABLE_ == 1)
/*****************************************************************************************************
* @brief  Configures the system clocks.
* @retval None
*******************************************************************************************************/
void MCU_SleepModeProcess(void)
{
	EXTI_InitTypeDef EXTI_InitStruct = {0};
//#if	(MDEBIO_ENABLE == 1)	
//	MDBIO_P0_SET();
//#endif	
	/* UART_RXD to GPIO mode */	
	AFIO_GPxConfig(UART_RXD_AFIO_PORT, UART_RXD, AFIO_FUN_GPIO);
	GPIO_DirectionConfig(UART_RXD_PORT,UART_RXD,GPIO_DIR_IN);
   GPIO_InputConfig(UART_RXD_PORT,UART_RXD,ENABLE);	
	AFIO_EXTISourceConfig(UART_WAKEUP_EXIT_CH, UART_WAKEUP_ESS_PORT);	
	EXTI_InitStruct.EXTI_Channel = UART_WAKEUP_EXIT_CH;
	EXTI_InitStruct.EXTI_IntType = EXTI_NEGATIVE_EDGE;
	EXTI_InitStruct.EXTI_Debounce = EXTI_DEBOUNCE_DISABLE;
	EXTI_InitStruct.EXTI_DebounceCnt = 00;
	EXTI_Init(&EXTI_InitStruct);	
	BTN_WakeupConfig(ENABLE);
	EXTI_WakeupEventConfig(UART_WAKEUP_EXIT_CH,EXTI_WAKEUP_LOW_LEVEL, ENABLE);
	BTN_ClearWakeupFlag();
	EXTI_ClearWakeupFlag(UART_WAKEUP_EXIT_CH);
	PWRCU_DeepSleep1(PWRCU_SLEEP_ENTRY_WFE);
	/* UART_RXD to UART mode */	
	AFIO_GPxConfig(UART_RXD_AFIO_PORT, UART_RXD, UART_RXD_AFIO_FUN);
	BTN_ClearWakeupFlag();
	EXTI_ClearWakeupFlag(UART_WAKEUP_EXIT_CH);
//#if	(MDEBIO_ENABLE == 1)		
//	MDBIO_P0_CLR();
//#endif	
}
#endif
/*****************************************************************************************************
* @brief  Configures the system clocks.
* @retval None
*******************************************************************************************************/
void MCU_gpio_Configuration(void)
{
//#if	(MDEBIO_ENABLE == 1)
//	AFIO_GPxConfig(MDBIO_P0_AFIO_PORT, MDBIO_P0, MDBIO_P0_AFIO_FUN);
//	AFIO_GPxConfig(MDBIO_P1_AFIO_PORT, MDBIO_P1, MDBIO_P1_AFIO_FUN);

//	GPIO_DirectionConfig(MDBIO_P0_PORT,MDBIO_P0,GPIO_DIR_OUT);
//	MDBIO_P0_CLR();
//	GPIO_DirectionConfig(MDBIO_P1_PORT,MDBIO_P1,GPIO_DIR_OUT);
//	MDBIO_P1_CLR();
//#endif
//	
//	AFIO_GPxConfig(GPIO_PA, GPIO_PIN_0 | GPIO_PIN_1, AFIO_FUN_GPIO);
//	GPIO_DirectionConfig(HT_GPIOA,GPIO_PIN_0 | GPIO_PIN_1,GPIO_DIR_IN);
//   GPIO_InputConfig(HT_GPIOA,GPIO_PIN_0 | GPIO_PIN_1,ENABLE);	
}
/*******************************************************************************************************
 * @brief  Configures the system clocks.
 * @retval None
 *******************************************************************************************************/
/*
//  <h> Clock Control Configuration
//  	<h> Communication
//    	<q0.12> EBI
//    	<q1.0> I2C0		<q1.1> I2C1
//    	<q1.25> I2S
//    	<q1.24> SCI0	<q1.27> SCI1
//    	<q1.4> SPI0 	<q1.5> SPI1
//    	<q1.8> USART0	<q1.9> USART1
//    	<q1.10> UART0  <q1.11> UART1
//    	<q0.10>  USB
//  	</h>
//  	<h> IO
//    	<q0.16> GPIO Port A <q0.17>  GPIO Port B <q0.18>  GPIO Port C <q0.19>  GPIO Port D
//    	<q1.14> AFIO
//    	<q1.15> EXTI
//  	</h>
//  	<h> System
//    	<q2.24> ADC
//    	<q0.11> CKREF
//    	<q0.13>  CRC
//    	<q2.22> CMP
//    	<q0.4>  PDMA
//    	<q2.6> PWRCU
//  	</h>
//  	<h> Timer
//    	<q2.16> BFTM0 <q2.17> BFTM1
//    	<q2.28> SCTM0 <q2.29> SCTM1 <q2.30> SCTM2 <q2.31> SCTM3
//    	<q2.8> GPTM0 <q2.9> GPTM1
//    	<q2.0> MCTM0
//    	<q2.6> RTC   <q2.4> WDT
//  	</h>
//  </h>
*/
#define	_CKCU_AHBCCR_		(0x000F0800)
#define	_CKCU_APBCR0_		(0x0000CF33)
#define	_CKCU_APBCR1_		(0x10030000)

void CKCU_Configuration(void)
{
	CKCU_PeripClockConfig_TypeDef cken;

   /* APB Peripheral Clock Selection to CK_AHB or CK_AHB/4 */
   HT_CKCU->APBPCSR0 = 0;           /* Reset value of APBPCSR0   */
   HT_CKCU->APBPCSR1 = 0;           /* Reset value of APBPCSR1   */

   /* Configure the CK_ADC prescaler(CK_ADC) = HCLK / 1 */
   CKCU_SetADCPrescaler(CKCU_ADCPRE_DIV1);
	/* Configure the AHB/APB clock control */
	cken.Reg[0] = _CKCU_AHBCCR_;
	cken.Reg[1] = _CKCU_APBCR0_;
	cken.Reg[2] = _CKCU_APBCR1_;
   CKCU_PeripClockConfig(cken,ENABLE);
}

void BaudRateDefault(u32 br)
{
	/* config UART_RXD for output mode */
	/* For configure BC7701 buad rate*/
	AFIO_GPxConfig(GPIO_PC, GPIO_PIN_1, AFIO_FUN_GPIO);
	AFIO_GPxConfig(GPIO_PC, GPIO_PIN_3, AFIO_FUN_GPIO);
   /* configure TXD & RXD pull-up function enabled  */
	GPIO_PullResistorConfig(HT_GPIOC,GPIO_PIN_1,GPIO_PR_UP);
	GPIO_PullResistorConfig(HT_GPIOC,GPIO_PIN_3,GPIO_PR_UP);

	GPIO_DirectionConfig(HT_GPIOC,GPIO_PIN_1,GPIO_DIR_IN);
	GPIO_DirectionConfig(HT_GPIOC,GPIO_PIN_3,GPIO_DIR_OUT);
	/* For configure BC7701 buad rate*/
	/* BC7701 TXD=1 & RXD=1, buad rate = 115200 */
	/* BC7701 TXD=1 & RXD=0, buad rate = 9600 */
	if(br == 9600)
		HT_GPIOC->RR = GPIO_PIN_3;		//MCU RXD->BC7701 TXD=0
	else
		HT_GPIOC->SRR = GPIO_PIN_3;   //MCU RXD->BC7701 TXD=1
}

